Attribute VB_Name = "Cmmsdk"
' --------------------------------------------------------------
'            Copyright (C) 2000-2008 COMIZOA Co., LTD.          
' --------------------------------------------------------------

' DATE  : 2008-08-22
' TIME  : 16:22:01

'******************************************************************************
'* [ CmmsdkDef.h ]
'* Header file for definitions of constants and data in CMMSDK library
'* - Update Data: 2007/01/12
'* - Provider: COMIZOA Co., Ltd.
'* - Phone: +82-42-936-6500~6
'* - Fax  : +82-42-936-6507
'* - URL  : http://www.comizoa.co.kr,  http://www.comizoa.com
'*******************************************************************************

        '*******************************************************************************

        ' Device ID definition
Public Const COMI_SD401 = &HB401
Public Const COMI_SD402 = &HB402
Public Const COMI_SD403 = &HB403
Public Const COMI_SD404 = &HB404
Public Const COMI_SD414 = &HB414
Public Const COMI_SD424 = &HB424
Public Const COMI_LX501 = &HA501
Public Const COMI_LX502 = &HA502
Public Const COMI_LX504 = &HA504
Public Const COMI_LX508 = &HA508
Public Const COMI_LX534 = &HA534
Public Const COMI_LX544 = &HA544
Public Const COMI_LX504A = &HA544

        ' Definition of maximum number of things
Public Const CMM_MAX_NUM_MOT_DEV = 16
        ' Maximum number of Motion Devices in one PC
Public Const CMM_MAX_NUM_DIO_DEV = 16
        ' Maximum number of Digital I/O Devices in one PC
Public Const CMM_MAX_NUM_AXES = 64
        ' Maximum number of motion axes
Public Const CMM_MAX_DI_CH = 512
        ' Maximum number of D/I channels
Public Const CMM_MAX_DO_CH = 512
        ' Maximum number of D/O channels
Public Const CMM_MAX_STR_LEN_AXIS_TITLE = 30
        ' Maximum string length of axis title
Public Const CMM_MAX_STR_LEN_DIST_UNIT = 30
        ' Maximum string length of distance unit
Public Const CMM_MAX_STR_LEN_VEL_UNIT = 30
        ' Maximum string length of velocity unit
Public Const CMM_MAX_STR_LEN_ERR = 128
        ' Maximum error string length: a buffer to receive error string must be larger than this size.

        ' Motion Chip Main-space Address
Public Const COMW = 0
Public Const OTPW = 1
Public Const BUF0 = 2
Public Const BUF1 = 3
Public Const MSTSW = 0
Public Const SSTSW = 1

        ' Motion Chip Registers
        
Public Const PRMV = 0
Public Const PRFL = 1
Public Const PRFH = 2
Public Const PRUR = 3
Public Const PRDR = 4
Public Const PRMG = 5
Public Const PRDP = 6
Public Const PRMD = 7
Public Const PRIP = 8
Public Const PRUS = 9
Public Const PRDS = 10
Public Const PRCP5 = 11
Public Const PRCI = 12

Public Const RMV = 16
Public Const RFL = 17
Public Const RFH = 18
Public Const RUR = 19
Public Const RDR = 20
Public Const RMG = 21
Public Const RDP = 22
Public Const RMD = 23
Public Const RIP = 24
Public Const RUS = 25
Public Const RDS = 26
Public Const RFA = 27
Public Const RENV1 = 28
Public Const RENV2 = 29
Public Const RENV3 = 30
Public Const RENV4 = 31
Public Const RENV5 = 32
Public Const RENV6 = 33
Public Const RENV7 = 34

Public Const RCUN1 = 35
Public Const RCUN2 = 36
Public Const RCUN3 = 37
Public Const RCUN4 = 38
Public Const RCMP1 = 39
Public Const RCMP2 = 40
Public Const RCMP3 = 41
Public Const RCMP4 = 42
Public Const RCMP5 = 43
Public Const RIRQ = 44
Public Const RLTC1 = 45
Public Const RLTC2 = 46
Public Const RLTC3 = 47
Public Const RLTC4 = 48

Public Const RSTS = 49
Public Const REST = 50
Public Const RIST = 51
Public Const RPLS = 52
Public Const RSPD = 53
Public Const PSDC = 54

Public Const RCI = 60
Public Const RCIC = 61

Public Const RIPS = 63
        

        '***********************************************************************************************

        '                                                               CONSTATNS for User                                                                                              *

        '***********************************************************************************************

        ' Boolean type definition
         
Public Const cmFALSE = 0
Public Const cmTRUE = 1
        

        '/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        ' MIO Property ID

        ' <TCmMioPropId>  <TCmMioPropIdEx>   MIO Property ID Ÿ Դϴ. <TCmMioPropIdEx> 

        ' <TCmMioPropId>  ̸ ٲپ Դϴ.     ߿ ƹų ص ˴ϴ.
        
Public Const cmALM_LOGIC = 0
Public Const cmALM_MODE = 1
Public Const cmCMP_LOGIC = 2
Public Const cmDR_LOGIC = 3
Public Const cmEL_LOGIC = 4
Public Const cmEL_MODE = 5
Public Const cmERC_LOGIC = 6
Public Const cmERC_OUT = 7
Public Const cmEZ_LOGIC = 8
Public Const cmINP_EN = 9
Public Const cmINP_LOGIC = 10
Public Const cmLTC_LOGIC = 11
Public Const cmLTC_LTC2SRC = 12
Public Const cmORG_LOGIC = 13
Public Const cmSD_EN = 14
Public Const cmSD_LOGIC = 15
Public Const cmSD_LATCH = 16
Public Const cmSD_MODE = 17
Public Const cmSTA_MODE = 18
Public Const cmSTA_TRG = 19
Public Const cmSTP_MODE = 20
Public Const cmCLR_CNTR = 21
Public Const cmCLR_SIGTYPE = 22
Public Const cmCMP_PWIDTH = 23
Public Const cmERC_ONTIME = 24
Public Const cmSVON_LOGIC = 25
Public Const cmERC_OUT_EL = 26
Public Const cmCNT_D_SRC = 27
Public Const cmCNT_G_SRC = 28
        
        
Public Const cmMPID_ALM_LOGIC = 0
Public Const cmMPID_ALM_MODE = 1
Public Const cmMPID_CMP_LOGIC = 2
Public Const cmMPID_DR_LOGIC = 3
Public Const cmMPID_EL_LOGIC = 4
Public Const cmMPID_EL_MODE = 5
Public Const cmMPID_ERC_LOGIC = 6
Public Const cmMPID_ERC_OUT = 7
Public Const cmMPID_EZ_LOGIC = 8
Public Const cmMPID_INP_EN = 9
Public Const cmMPID_INP_LOGIC = 10
Public Const cmMPID_LTC_LOGIC = 11
Public Const cmMPID_LTC_LTC2SRC = 12
Public Const cmMPID_ORG_LOGIC = 13
Public Const cmMPID_SD_EN = 14
Public Const cmMPID_SD_LOGIC = 15
Public Const cmMPID_SD_LATCH = 16
Public Const cmMPID_SD_MODE = 17
Public Const cmMPID_STA_MODE = 18
Public Const cmMPID_STA_TRG = 19
Public Const cmMPID_STP_MODE = 20
Public Const cmMPID_CLR_CNTR = 21
Public Const cmMPID_CLR_SIGTYPE = 22
Public Const cmMPID_CMP_PWIDTH = 23
Public Const cmMPID_ERC_ONTIME = 24
Public Const cmMPID_SVON_LOGIC = 25
Public Const cmMPID_ERC_OUT_EL = 26
Public Const cmMPID_CNT_D_SRC = 27
Public Const cmMPID_CNT_G_SRC = 28
        

        ' Bit order of StReadMioStatuses() return value
        
Public Const cmIOST_RDY = 0
Public Const cmIOST_ALM = 1
Public Const cmIOST_ELP = 2
Public Const cmIOST_ELN = 3
Public Const cmIOST_ORG = 4
Public Const cmIOST_DIR = 5
Public Const cmIOST_RSV1 = 6
Public Const cmIOST_PCS = 7
Public Const cmIOST_ERC = 8
Public Const cmIOST_EZ = 9
Public Const cmIOST_CLR = 10
Public Const cmIOST_LTC = 11
Public Const cmIOST_SD = 12
Public Const cmIOST_INP = 13
Public Const cmIOST_DRP = 14
Public Const cmIOST_DRN = 15
Public Const cmIOST_STA = 16
Public Const cmIOST_STP = 17
        

        ' Motion operation status ID
         
Public Const cmMST_STOP = 0
Public Const cmMST_WAIT_DR = 1
Public Const cmMST_WAIT_STA = 2
Public Const cmMST_WAIT_INSYNC = 3
Public Const cmMST_WAIT_OTHER = 4
Public Const cmMST_WAIT_ERC = 5
Public Const cmMST_WAIT_DIR = 6
Public Const cmMST_RESERVED1 = 7
Public Const cmMST_WAIT_PLSR = 8
Public Const cmMST_IN_RVSSPD = 9
Public Const cmMST_IN_INISPD = 10
Public Const cmMST_IN_ACC = 11
Public Const cmMST_IN_WORKSPD = 12
Public Const cmMST_IN_DEC = 13
Public Const cmMST_WAIT_INP = 14
Public Const cmMST_SPARE0 = 15
        

        ' Signal logic definition
         

Public Const cmLOGIC_A = 0
        'Normal open
Public Const cmLOGIC_B = 1
        'Normal close
        

        ' Axis index definition
         
Public Const cmX1 = 0
Public Const cmY1 = 1
Public Const cmZ1 = 2
Public Const cmU1 = 3
Public Const cmX2 = 4
Public Const cmY2 = 5
Public Const cmZ2 = 6
Public Const cmU2 = 7
        

        ' Definition for axes mask
         

Public Const cmX1_MASK = &H1
Public Const cmY1_MASK = &H2
Public Const cmZ1_MASK = &H4
Public Const cmU1_MASK = &H8

Public Const cmX2_MASK = &H10
Public Const cmY2_MASK = &H20
Public Const cmZ2_MASK = &H40
Public Const cmU2_MASK = &H80
        

        ' Encoder and PA/PB input mode definition
         
Public Const cmIMODE_AB1X = 0
Public Const cmIMODE_AB2X = 1
Public Const cmIMODE_AB4X = 2
Public Const cmIMODE_CWCCW = 3
Public Const cmIMODE_STEP = 4
        

        ' Command output mode definition
         
Public Const cmOMODE_PDIR0 = 0
Public Const cmOMODE_PDIR1 = 1
Public Const cmOMODE_PDIR2 = 2
Public Const cmOMODE_PDIR3 = 3
Public Const cmOMODE_CWCCW0 = 4
Public Const cmOMODE_CWCCW1 = 5
Public Const cmOMODE_CCWCW0 = 6
Public Const cmOMODE_CCWCW1 = 7
        

        ' Control Mode
         
Public Const cmCTRL_OPEN = 0
        ' Open loop control mode
Public Const cmCTRL_SEMI_C = 1
        ' Semi-closed loop control mode (applied only to absolute in-position commands)
Public Const cmCTRL_FULL_C = 2
        ' Full-closed loop control mode (this is not supported at current version)
        
        

        ' (Linear)Operation direction
        
Public Const cmDIR_N = 0
        '(-)Dir
Public Const cmDIR_P = 1
        '(+)Dir
        

        ' Counter name
         

Public Const cmCNT_COMM = 0
        'Command
Public Const cmCNT_FEED = 1
        'Feedback
Public Const cmCNT_DEV = 2
        'Deviation

Public Const cmCNT_GEN = 3
        'General
Public Const cmCNT_REM = 4
        'Remained
        

        ' Speed mode index definition
         

Public Const cmSMODE_KEEP = -1
        ' Keep previous setting
Public Const cmSMODE_C = 0
        'Constant
Public Const cmSMODE_T = 1
        'Trapeziodal
Public Const cmSMODE_S = 2
        'S-curve
        

        ' Arc operation direction
         
Public Const cmARC_CW = 0
Public Const cmARC_CCW = 1
        

        ' Compare Method
        
Public Const cmDISABLE = 0
Public Const cmEQ_BIDIR = 1
Public Const cmEQ_PDIR = 2
Public Const cmEQ_NDIR = 3
Public Const cmLESS = 4
        'Cnt<Data
Public Const cmGREATER = 5
        'Cnt>Data
        

        ' Action when general comparator met the condition
        
Public Const cmEVNT_ONLY = 0
Public Const cmEVNT_IS = 1
Public Const cmEVNT_DS = 2
Public Const cmEVNT_SPDCHG = 3
        

        ' Backlash/Slip correction mode
        
Public Const cmCORR_DIS = 0
        ' Disable correction
Public Const cmCORR_BACK = 1
        ' Backlash correction mode
Public Const cmCORR_SLIP = 2
        ' Slip correction mode
        
        
Public Const cmEXOPT_SET_USE_PREREG = 0
        

        ' Interrupt Handler Type
        

Public Const cmIHT_MESSAGE = 0
Public Const cmIHT_EVENT = 1
Public Const cmIHT_CALLBACK = 2
        

        ' Interrupt Handler Type
        
Public Const cmSTR_AXIS_NAME = 0
Public Const cmSTR_DIST_UNIT = 1
Public Const cmSTR_SPEED_UNIT = 2
        

        ' Sequence Mode
        
Public Const cmSEQM_SKIP_RUN = 0
Public Const cmSEQM_WAIT_RUN = 1
        

        ' Map Type
        
Public Const cmDMAP_MOTION = 0
Public Const cmDMAP_DIO = 1
Public Const cmDMAP_ALL = 2
        

        ' SetFilterAB 
        
Public Const cmAB_ENC = 0
Public Const cmAB_PULSAR = 1
        

        ' Axis Capability ID
        

Public Const cmCAPX_CMD_DIR = 0
        ' Command direction change function
Public Const cmCAPX_EL_MAN_SET = 1
        ' -/+EL Manual control function
Public Const cmCAPX_CMP_HIGH = 2
        ' High-speed Compare Output function
        
        
Public Const cmHPCM_M0 = 0
        ' ORG(/EL/EZ) ȣ ߻  COMMAND & FEEDBACK ġ 0 ŬѴ.
Public Const cmHPCM_M1 = 1
        ' ͸  Ϸϰ  COMMAND & FEEDBACK ġ  0 ŬѴ.
Public Const cmHPCM_M2 = 2
        ' ͸  Ϸϰ  FEEDBACK ġ ״ ΰ COMMAND ġ FEEDBACK ġ ġŲ.
        

        ' Sync mode
        
Public Const cmSYNC_DISABLE = 0
Public Const cmSYNC_INT_SYNC = 1
Public Const cmSYNC_OTHER_STOP = 2
        

        ' Internal sync. conditions
        
Public Const cmISYNC_ACC_STA = 0
        ' 0: at start of acceleration
Public Const cmISYNC_ACC_END = 1
        ' 1: at end of acceleration
Public Const cmISYNC_DEC_STA = 2
        ' 2: at start of deceleration
Public Const cmISYNC_DEC_END = 3
        ' 3: at end of deceleration
Public Const cmISYNC_SLN = 4
        ' 4: when (-)software limit met
Public Const cmISYNC_SLP = 5
        ' 5: when (+)software limit met
Public Const cmISYNC_GCMP = 6
        ' 6: when General Comparator condition is satisfied
Public Const cmISYNC_TCMP = 7
        ' 7: when Trigger Comparator condition is satisfied
        

        '***********************************************************************************************

        '                                                               FUNCTION Prototype                                                                                              *

        '***********************************************************************************************

        ' Interrupt Handler Callback Function Prototype

        ' Informations of all actually installed motion devices

        ' Informations of motion devices defined by user

        '------------------- DIO Device Informations -----------------------------------------------------------

        ' Informations of a DIO device

        ' Informations of all actually installed DIO devices

        ' Informations of DIO devices defined by user

        '-------------------- MOTION CONFIGURATION ------------------------------------------------------------

        '------------------------------------------------------------------------------------------------------

        '--------------------------------- CME FILE STRUCTURE (ALL) --------------------------------------------

        '***********************************************************************************************

        '                                                                       ERROR CODE DEFINITIONs                                                                          *

        '***********************************************************************************************
Public Const cmERR_NONE = 0
Public Const cmERR_MEM_ALLOC_FAIL = -290
        ' Memory allocation fail
Public Const cmERR_GLOBAL_MEM_FAIL = -292
        ' Global memory allocation fail
Public Const cmERR_ISR_CONNEC_FAIL = -310
        ' ISR registration fail
Public Const cmERR_DIVIDE_BY_ZERO = -400
        ' Cause divide by zero error
Public Const cmERR_WORNG_NUM_DATA = -500
        ' Number of data is too small or too big
Public Const cmERR_VER_MISMATCH = -600
        ' Version(of file or device) mismatch
Public Const cmERR_INVALID_DEVICE_ID = -1010
        ' Invalid device id > Load Device Ǵ SetDeviceId()...
Public Const cmERR_INVALID_HANDLE = -1020
Public Const cmERR_UNSUPORTED_FUNC = -1030
Public Const cmERR_INVALID_PARAMETER = -1101
Public Const cmERR_INVALID_CHANNEL = -1105
Public Const cmERR_INVALID_INPUT_RANGE = -1111
        ' Invalid range value (AI, AO)
Public Const cmERR_INVALID_FREQ_RANGE = -1121
        ' Invalid input or output frequency
Public Const cmERR_FILE_CREATE_FAIL = -1501
        ' File create fail
Public Const cmERR_FILE_OPEN_FAIL = -1511
        ' File open fail
Public Const cmERR_FILE_READ_FAIL = -1522
        ' File reading fail
Public Const cmERR_EVENT_CREATE_FAIL = -1550
        ' Event handle creation fail
Public Const cmERR_INT_INSTANCE_FAIL = -1560
        ' Interrupt event instance creation fail
Public Const cmERR_DITHREAD_CRE = -1570
        ' D/I state change monitor thread creation fail
Public Const cmERR_BUFFER_SMALL = -1580
        ' Buffer size is too small
Public Const cmERR_HIGH_TIMER_UNSUPP = -1590
        ' The installed hardware does not support a high-resolution performance counter (cmmUtlDelayMicroSec() function fails)
Public Const cmERR_OUT_OF_RANGE = -1600
        ' The range of some parameter is out of range
Public Const cmERR_ON_MOTION = -5001
Public Const cmERR_STOP_BY_SLP = -5002
        ' Abnormally stopped by positive soft limit
Public Const cmERR_STOP_BY_SLN = -5003
        ' Abnormally stopped by negative soft limit
Public Const cmERR_STOP_BY_CMP3 = -5004
        ' Abnormally stopped by comparator3
Public Const cmERR_STOP_BY_CMP4 = -5005
        ' Abnormally stopped by comparator4
Public Const cmERR_STOP_BY_CMP5 = -5006
        ' Abnormally stopped by comparator5
Public Const cmERR_STOP_BY_ELP = -5007
        ' Abnormally stopped by (+) external limit
Public Const cmERR_STOP_BY_ELN = -5008
        ' Abnormally stopped by (-) external limit
Public Const cmERR_STOP_BY_ALM = -5009
        ' Abnormally stopped by alarm input signal
Public Const cmERR_STOP_BY_CSTP = -5010
        ' Abnormally stopped by CSTP input signal
Public Const cmERR_STOP_BY_CEMG = -5011
        ' Abnormally stopped by CEMG input signal
Public Const cmERR_STOP_BY_SD = -5012
        ' Abnormally stopped by SD input signal
Public Const cmERR_STOP_BY_DERROR = -5013
        ' Abnormally stopped by operation data error
Public Const cmERR_STOP_BY_IP = -5014
        ' Abnormally stopped by other axis error during interpolation
Public Const cmERR_STOP_BY_PO = -5015
        ' An overflow occurred in the PA/PB input buffer
Public Const cmERR_STOP_BY_AO = -5016
        ' Out of range position counter during interpolation
Public Const cmERR_STOP_BY_EE = -5017
        ' An EA/EB input error occurred (does not stop)
Public Const cmERR_STOP_BY_PE = -5018
        ' An PA/PB input error occurred (does not stop)
Public Const cmERR_STOP_BY_SLVERR = -5019
        ' Abnormally stopped because slave axis has been stopped
Public Const cmERR_STOP_BY_SEMG = -5020
        ' Abnormally stopped by software emergency setting
Public Const cmERR_MOT_MAOMODE = -5110
        ' Master output mode is not CW/CCW mode // Master/Slave ۽ÿ Master output尡 CW/CCW尡 ƴϴ.
Public Const cmERR_MOT_SLAVE_SET = -5120
        ' Slave start fail (Motion state "Wait for Pulsar Input"  ʴ´.
Public Const cmERR_SPEED_RANGE_OVER = -5130
Public Const cmERR_INVALID_SPEED_SET = -5140
        ' Speed setting value is not valid
Public Const cmERR_INVALID_IXMAP = -5150
        ' Invalid interpolation map
Public Const cmERR_INVALID_LMMAP = -5160
        ' Invalid List-Motion Map
Public Const cmERR_MOT_SEQ_SKIPPED = -5170
        ' Motion command is skipped because the axis is already running.
Public Const cmERR_CMPIX_INVALID_MAP = -5180
        ' Interpolated position compare output map is not valid
Public Const cmERR_INVALID_ARC_POS = -5190
        ' Arc-interpolation position data is invalid
Public Const cmERR_UNKNOWN = -9999
'******************************************************************************
'* [ Cmmsdk.h ]
'* Header file for API fuctions in CMMSDK library
'* - Update Data: 2008/04/21
'* - Provider: COMIZOA Co., Ltd.
'* - Phone: +82-42-936-6500~6
'* - Fax  : +82-42-936-6507
'* - URL  : http://www.comizoa.co.kr,  http://www.comizoa.com
'*******************************************************************************
'*******************************************************************************
'*******************************************************************************************************
'                                                               API FUNCTIONS                                                           *
'*******************************************************************************************************
''////////////////////////////////////////////////////////////////////////////////////////////////////
' SetBit() :   Ư Ʈ  Ѵ. ũ̹Ƿ Լ ȣ  ʵʿ !
' v: , n:bitȣ, s:氪(state)
''////////////////////////////////////////////////////////////////////////////////////////////////////
' GetBit() :   Ư Ʈ  ȯѴ. ũ̹Ƿ Լ ȣ  ʵʿ !
' v: , n:bitȣ
'====================== DLL LOAD/UNLOAD FUNCTIONS ============================================
'====================== General FUNCTIONS ====================================================
Public Declare Function cmmGnDeviceLoad _
Lib "Cmmsdk.dll" _
(ByVal IsResetDevice As Long, ByRef NumAxes As Long) _
As Long

Public Declare Function cmmGnDeviceUnload _
Lib "Cmmsdk.dll" _
() _
As Long

Public Declare Function cmmGnDeviceIsLoaded _
Lib "Cmmsdk.dll" _
(ByRef IsLoaded As Long) _
As Long

Public Declare Function cmmGnDeviceReset _
Lib "Cmmsdk.dll" _
() _
As Long

Public Declare Function cmmGnInitFromFile _
Lib "Cmmsdk.dll" _
(ByVal szCmeFile As String) _
As Long

Public Declare Function cmmGnInitFromFile_MapOnly _
Lib "Cmmsdk.dll" _
(ByRef szCmeFile As String, ByVal MapType As Long) _
As Long

Public Declare Function cmmGnSetServoOn _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Enable As Long) _
As Long

Public Declare Function cmmGnGetServoOn _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef Enable As Long) _
As Long

Public Declare Function cmmGnSetAlarmRes _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByVal IsOn As Long) _
As Long

Public Declare Function cmmGnGetAlarmRes _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByRef IsOn As Long) _
As Long

Public Declare Function cmmGnPulseAlarmRes _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByVal IsOnPulse As Long, ByVal dwDuration As Long, ByVal IsWaitPulseEnd As Long) _
As Long

Public Declare Function cmmGnSetSimulMode _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal IsSimulMode As Long) _
As Long

Public Declare Function cmmGnGetSimulMode _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef IsSimulMode As Long) _
As Long

Public Declare Function cmmGnPutInternalSTA _
Lib "Cmmsdk.dll" _
(ByVal AxesMask As Long) _
As Long

Public Declare Function cmmGnSetEmergency _
Lib "Cmmsdk.dll" _
(ByVal IsEnable As Long, ByVal IsDecStop As Long) _
As Long

Public Declare Function cmmGnGetEmergency _
Lib "Cmmsdk.dll" _
(ByRef IsEnabled As Long) _
As Long

Public Declare Function cmmGnBitShift _
Lib "Cmmsdk.dll" _
(ByVal Value As Long, ByVal ShiftOption As Long, ByRef Result As Long) _
As Long

'====================== Configuration FUNCTIONS ==============================================
Public Declare Function cmmCfgSetMioProperty _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal PropId As Long, ByVal PropVal As Long) _
As Long

Public Declare Function cmmCfgGetMioProperty _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal PropId As Long, ByRef PropVal As Long) _
As Long

Public Declare Function cmmCfgSetFilter _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal IsEnable As Long) _
As Long

Public Declare Function cmmCfgGetFilter _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef IsEnabled As Long) _
As Long

Public Declare Function cmmCfgSetFilterAB _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByVal Target As Long, ByVal IsEnable As Long) _
As Long

Public Declare Function cmmCfgGetFilterAB _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByVal Target As Long, ByRef IsEnabled As Long) _
As Long

Public Declare Function cmmCfgSetInMode _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal InputMode As Long, ByVal IsReverse As Long) _
As Long

Public Declare Function cmmCfgGetInMode _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef InputMode As Long, ByRef IsReverse As Long) _
As Long

Public Declare Function cmmCfgSetOutMode _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal OutputMode As Long) _
As Long

Public Declare Function cmmCfgGetOutMode _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef OutputMode As Long) _
As Long

Public Declare Function cmmCfgSetCtrlMode _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal CtrlMode As Long) _
As Long

Public Declare Function cmmCfgGetCtrlMode _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef CtrlMode As Long) _
As Long

Public Declare Function cmmCfgSetInOutRatio _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Ratio As Double) _
As Long

Public Declare Function cmmCfgGetInOutRatio _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef Ratio As Double) _
As Long

Public Declare Function cmmCfgSetUnitDist _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal UnitDist As Double) _
As Long

Public Declare Function cmmCfgGetUnitDist _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef UnitDist As Double) _
As Long

Public Declare Function cmmCfgSetUnitSpeed _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal UnitSpeed As Double) _
As Long

Public Declare Function cmmCfgGetUnitSpeed _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef UnitSpeed As Double) _
As Long

Public Declare Function cmmCfgSetSpeedRange _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal MaxPPS As Double) _
As Long

Public Declare Function cmmCfgGetSpeedRange _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef MinPPS As Double, ByRef MaxPPS As Double) _
As Long

Public Declare Function cmmCfgSetSpeedPattern _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal SpeedMode As Long, ByVal WorkSpeed As Double, ByVal Accel As Double, ByVal Decel As Double) _
As Long

Public Declare Function cmmCfgGetSpeedPattern _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef SpeedMode As Long, ByRef WorkSpeed As Double, ByRef Accel As Double, ByRef Decel As Double) _
As Long

Public Declare Function cmmCfgSetActSpdCheck _
Lib "Cmmsdk.dll" _
(ByVal IsEnable As Long, ByVal Interval As Long) _
As Long

Public Declare Function cmmCfgGetActSpdCheck _
Lib "Cmmsdk.dll" _
(ByRef IsEnable As Long, ByRef Interval As Long) _
As Long

Public Declare Function cmmCfgSetSoftLimit _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal IsEnable As Long, ByVal LimitN As Double, ByVal LimitP As Double) _
As Long

Public Declare Function cmmCfgGetSoftLimit _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef IsEnable As Long, ByRef LimitN As Double, ByRef LimitP As Double) _
As Long

Public Declare Function cmmCfgSetRingCntr _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByVal TargCntr As Long, ByVal IsEnable As Long, ByVal CntMax As Double) _
As Long

Public Declare Function cmmCfgGetRingCntr _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByVal TargCntr As Long, ByRef IsEnable As Long, ByRef CntMax As Double) _
As Long

Public Declare Function cmmCfgSetVelCorrRatio _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal fCorrRatio As Double) _
As Long

Public Declare Function cmmCfgGetVelCorrRatio _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByRef fCorrRatio As Double) _
As Long

Public Declare Function cmmCfgSetSeqMode _
Lib "Cmmsdk.dll" _
(ByVal SeqMode As Long) _
As Long

Public Declare Function cmmCfgGetSeqMode _
Lib "Cmmsdk.dll" _
(ByRef SeqMode As Long) _
As Long

Public Declare Function cmmCfgSetManExtLimit _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByVal IsSetELP As Long, ByVal IsEnable As Long, ByVal ManState As Long) _
As Long

Public Declare Function cmmCfgGetManExtLimit _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByVal IsGetELP As Long, ByRef IsEnable As Long, ByRef ManState As Long) _
As Long

'====================== HOME-RETURN FUNCTIONS ================================================
Public Declare Function cmmHomeSetConfig _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal HomeMode As Long, ByVal EzCount As Long, ByVal EscDist As Double, ByVal Offset As Double) _
As Long

Public Declare Function cmmHomeGetConfig _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef HomeMode As Long, ByRef EzCount As Long, ByRef EscDist As Double, ByRef Offset As Double) _
As Long

Public Declare Function cmmHomeSetPosClrMode _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal PosClrMode As Long) _
As Long

Public Declare Function cmmHomeGetPosClrMode _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef PosClrMode As Long) _
As Long

Public Declare Function cmmHomeSetSpeedPattern _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal SpeedMode As Long, ByVal Vel As Double, ByVal Accel As Double, ByVal Decel As Double, ByVal RevVel As Double) _
As Long

Public Declare Function cmmHomeGetSpeedPattern _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef SpeedMode As Long, ByRef Vel As Double, ByRef Accel As Double, ByRef Decel As Double, ByRef RevVel As Double) _
As Long

Public Declare Function cmmHomeMoveStart _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Direction As Long) _
As Long

Public Declare Function cmmHomeMove _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Direction As Long, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmHomeMoveAll _
Lib "Cmmsdk.dll" _
(ByVal NumAxes As Long, ByRef AxisList As Long, ByRef DirList As Long, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmHomeMoveAllStart _
Lib "Cmmsdk.dll" _
(ByVal NumAxes As Long, ByRef AxisList As Long, ByRef DirList As Long) _
As Long

Public Declare Function cmmHomeGetSuccess _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef IsSuccess As Long) _
As Long

Public Declare Function cmmHomeSetSuccess _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal IsSuccess As Long) _
As Long

Public Declare Function cmmHomeIsBusy _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef IsBusy As Long) _
As Long

Public Declare Function cmmHomeWaitDone _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal IsBlocking As Long) _
As Long

'====================== Single Axis Move FUNCTIONS ===========================================
Public Declare Function cmmSxSetSpeedRatio _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal SpeedMode As Long, ByVal VelRatio As Double, ByVal AccRatio As Double, ByVal DecRatio As Double) _
As Long

Public Declare Function cmmSxGetSpeedRatio _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef SpeedMode As Long, ByRef VelRatio As Double, ByRef AccRatio As Double, ByRef DecRatio As Double) _
As Long

Public Declare Function cmmSxMoveStart _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Distance As Double) _
As Long

Public Declare Function cmmSxMove _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Distance As Double, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmSxMoveToStart _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Position As Double) _
As Long

Public Declare Function cmmSxMoveTo _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Position As Double, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmSxVMoveStart _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Dir As Long) _
As Long

Public Declare Function cmmSxStop _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal IsWaitComplete As Long, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmSxStopEmg _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long) _
As Long

Public Declare Function cmmSxIsDone _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef IsDone As Long) _
As Long

Public Declare Function cmmSxWaitDone _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmSxGetTargetPos _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByRef Position As Double) _
As Long

Public Declare Function cmmSxOptSetIniSpeed _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal IniSpeed As Double) _
As Long

Public Declare Function cmmSxOptGetIniSpeed _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef IniSpeed As Double) _
As Long

Public Declare Function cmmSxSetCorrection _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal CorrMode As Long, ByVal CorrAmount As Double, ByVal CorrVel As Double, ByVal CntrMask As Long) _
As Long

Public Declare Function cmmSxGetCorrection _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef CorrMode As Long, ByRef CorrAmount As Double, ByRef CorrVel As Double, ByRef CntrMask As Long) _
As Long

Public Declare Function cmmSxOptSetSyncMode _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Mode As Long, ByVal RefAxis As Long, ByVal Condition As Long) _
As Long

Public Declare Function cmmSxOptGetSyncMode _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef Mode As Long, ByRef RefAxis As Long, ByRef Condition As Long) _
As Long

Public Declare Function cmmSxOptSetSyncOut _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Mode As Long, ByVal DoChan_local As Long, ByVal DoLogic As Long) _
As Long

Public Declare Function cmmSxOptGetSyncOut _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef Mode As Long, ByRef DoChan_local As Long, ByRef DoLogic As Long) _
As Long

Public Declare Function cmmSxOptSetRdpOffset _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal OffsetDist As Double) _
As Long

Public Declare Function cmmSxOptGetRdpOffset _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef OffsetDist As Double) _
As Long

'====================== Multiple Axes Move FUNCTIONS =========================================
Public Declare Function cmmMxMove _
Lib "Cmmsdk.dll" _
(ByVal NumAxes As Long, ByRef AxisList As Long, ByRef DistList As Double, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmMxVMoveStart _
Lib "Cmmsdk.dll" _
(ByVal NumAxes As Long, ByRef AxisList As Long, ByRef DirList As Long) _
As Long

Public Declare Function cmmMxMoveStart _
Lib "Cmmsdk.dll" _
(ByVal NumAxes As Long, ByRef AxisList As Long, ByRef DistList As Double) _
As Long

Public Declare Function cmmMxMoveTo _
Lib "Cmmsdk.dll" _
(ByVal NumAxes As Long, ByRef AxisList As Long, ByRef PosList As Double, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmMxMoveToStart _
Lib "Cmmsdk.dll" _
(ByVal NumAxes As Long, ByRef AxisList As Long, ByRef PosList As Double) _
As Long

Public Declare Function cmmMxStop _
Lib "Cmmsdk.dll" _
(ByVal NumAxes As Long, ByRef AxisList As Long, ByVal IsWaitComplete As Long, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmMxStopEmg _
Lib "Cmmsdk.dll" _
(ByVal NumAxes As Long, ByRef AxisList As Long) _
As Long

Public Declare Function cmmMxIsDone _
Lib "Cmmsdk.dll" _
(ByVal NumAxes As Long, ByRef AxisList As Long, ByRef IsDone As Long) _
As Long

Public Declare Function cmmMxWaitDone _
Lib "Cmmsdk.dll" _
(ByVal NumAxes As Long, ByRef AxisList As Long, ByVal IsBlocking As Long) _
As Long

'====================== Interpolation Move FUNCTIONS =========================================
Public Declare Function cmmIxMapAxes _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByVal MapMask1 As Long, ByVal MapMask2 As Long) _
As Long

Public Declare Function cmmIxSetSpeedPattern _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByVal IsVectorSpeed As Long, ByVal SpeedMode As Long, ByVal Vel As Double, ByVal Acc As Double, ByVal Dec As Double) _
As Long

Public Declare Function cmmIxGetSpeedPattern _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByRef IsVectorSpeed As Long, ByRef SpeedMode As Long, ByRef Vel As Double, ByRef Acc As Double, ByRef Dec As Double) _
As Long

Public Declare Function cmmIxLine _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByRef DistList As Double, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmIxLineStart _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByRef DistList As Double) _
As Long

Public Declare Function cmmIxLineTo _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByRef PosList As Double, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmIxLineToStart _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByRef PosList As Double) _
As Long

Public Declare Function cmmIxArcA _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByVal XCentOffset As Double, ByVal YCentOffset As Double, ByVal EndAngle As Double, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmIxArcAStart _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByVal XCentOffset As Double, ByVal YCentOffset As Double, ByVal EndAngle As Double) _
As Long

Public Declare Function cmmIxArcATo _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByVal XCent As Double, ByVal YCent As Double, ByVal EndAngle As Double, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmIxArcAToStart _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByVal XCent As Double, ByVal YCent As Double, ByVal EndAngle As Double) _
As Long

Public Declare Function cmmIxArcP _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByVal XCentOffset As Double, ByVal YCentOffset As Double, ByVal XEndPointDist As Double, ByVal YEndPointDist As Double, ByVal Direction As Long, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmIxArcPStart _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByVal XCentOffset As Double, ByVal YCentOffset As Double, ByVal XEndPointDist As Double, ByVal YEndPointDist As Double, ByVal Direction As Long) _
As Long

Public Declare Function cmmIxArcPTo _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByVal XCent As Double, ByVal YCent As Double, ByVal XEndPos As Double, ByVal YEndPos As Double, ByVal Direction As Long, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmIxArcPToStart _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByVal XCent As Double, ByVal YCent As Double, ByVal XEndPos As Double, ByVal YEndPos As Double, ByVal Direction As Long) _
As Long

Public Declare Function cmmIxArc3PStart _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByVal P2X As Double, ByVal P2Y As Double, ByVal P3X As Double, ByVal P3Y As Double, ByVal EndAngle As Double) _
As Long

Public Declare Function cmmIxArc3P _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByVal P2X As Double, ByVal P2Y As Double, ByVal P3X As Double, ByVal P3Y As Double, ByVal EndAngle As Double, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmIxArc3PToStart _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByVal P2X As Double, ByVal P2Y As Double, ByVal P3X As Double, ByVal P3Y As Double, ByVal EndAngle As Double) _
As Long

Public Declare Function cmmIxArc3PTo _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByVal P2X As Double, ByVal P2Y As Double, ByVal P3X As Double, ByVal P3Y As Double, ByVal EndAngle As Double, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmIxIsDone _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByRef IsDone As Long) _
As Long

Public Declare Function cmmIxWaitDone _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmIxStop _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long, ByVal IsWaitComplete As Long, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmIxStopEmg _
Lib "Cmmsdk.dll" _
(ByVal MapIndex As Long) _
As Long

Public Declare Function cmmIxxHelOnceSetSpeed _
Lib "Cmmsdk.dll" _
(ByVal HelId As Long, ByVal Master As Long, ByVal SpeedMode As Long, ByVal WorkSpeed As Double, ByVal Acc As Double, ByVal Dec As Double) _
As Long

Public Declare Function cmmIxxHelOnceGetSpeed _
Lib "Cmmsdk.dll" _
(ByVal HelId As Long, ByRef SpeedMaster As Long, ByRef SpeedMode As Long, ByRef WorkSpeed As Double, ByRef Acc As Double, ByRef Dec As Double) _
As Long

Public Declare Function cmmIxxHelOnce _
Lib "Cmmsdk.dll" _
(ByVal HelId As Long, ByVal NumAxes As Long, ByRef AxisList As Long, ByRef CoordList As Double, ByVal ArcAngle As Double, ByRef DistU As Double, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmIxxHelOnceStart _
Lib "Cmmsdk.dll" _
(ByVal HelId As Long, ByVal NumAxes As Long, ByRef AxisList As Long, ByRef CoordList As Double, ByVal ArcAngle As Double, ByRef DistU As Double) _
As Long

Public Declare Function cmmIxxSplineBuild _
Lib "Cmmsdk.dll" _
(ByRef InArray As Double, ByVal NumInArray As Long, ByRef OutArray As Double, ByVal NumOutArray As Long) _
As Long

'====================== External Switch Move FUNCTIONS =======================================
Public Declare Function cmmExVMoveStart _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long) _
As Long

Public Declare Function cmmExMoveStart _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Distance As Double) _
As Long

Public Declare Function cmmExMoveToStart _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Position As Double) _
As Long

'====================== Manual Pulsar FUNCTIONS ==============================================
Public Declare Function cmmPlsrSetInMode _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal InputMode As Long, ByVal IsInverse As Long) _
As Long

Public Declare Function cmmPlsrGetInMode _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef InputMode As Long, ByRef IsInverse As Long) _
As Long

Public Declare Function cmmPlsrSetGain _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal GainFactor As Long, ByVal DivFactor As Long) _
As Long

Public Declare Function cmmPlsrGetGain _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef GainFactor As Long, ByRef DivFactor As Long) _
As Long

Public Declare Function cmmPlsrHomeMoveStart _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal HomeType As Long) _
As Long

Public Declare Function cmmPlsrMoveStart _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Distance As Double) _
As Long

Public Declare Function cmmPlsrMove _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Distance As Double, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmPlsrMoveToStart _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Position As Double) _
As Long

Public Declare Function cmmPlsrMoveTo _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Position As Double, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmPlsrVMoveStart _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long) _
As Long

Public Declare Function cmmPlsrIsActive _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByRef IsActive As Long) _
As Long

'====================== MASTER/SLAVE FUNCTIONS ===============================================
Public Declare Function cmmMsRegisterSlave _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal MaxSpeed As Double, ByVal IsInverse As Long) _
As Long

Public Declare Function cmmMsUnregisterSlave _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long) _
As Long

Public Declare Function cmmMsCheckSlaveState _
Lib "Cmmsdk.dll" _
(ByVal SlaveAxis As Long, ByRef SlaveState As Long) _
As Long

Public Declare Function cmmMsGetMasterAxis _
Lib "Cmmsdk.dll" _
(ByVal SlaveAxis As Long, ByRef MasterAxis As Long) _
As Long

'====================== Overriding FUNCTIONS =================================================
Public Declare Function cmmOverrideSpeedSet _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long) _
As Long

Public Declare Function cmmOverrideSpeedSetAll _
Lib "Cmmsdk.dll" _
(ByVal NumAxes As Long, ByRef AxisList As Long) _
As Long

Public Declare Function cmmOverrideMove _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal NewDistance As Double, ByRef IsIgnored As Long) _
As Long

Public Declare Function cmmOverrideMoveTo _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal NewPosition As Double, ByRef IsIgnored As Long) _
As Long

'====================== LIST-MOTION FUNCTIONS ================================================
Public Declare Function cmmLmMapAxes _
Lib "Cmmsdk.dll" _
(ByVal LmIndex As Long, ByVal MapMask1 As Long, ByVal MapMask2 As Long) _
As Long

Public Declare Function cmmLmBeginList _
Lib "Cmmsdk.dll" _
(ByVal LmIndex As Long) _
As Long

Public Declare Function cmmLmEndList _
Lib "Cmmsdk.dll" _
(ByVal LmIndex As Long) _
As Long

Public Declare Function cmmLmStartMotion _
Lib "Cmmsdk.dll" _
(ByVal LmIndex As Long) _
As Long

Public Declare Function cmmLmAbortMotion _
Lib "Cmmsdk.dll" _
(ByVal LmIndex As Long) _
As Long

Public Declare Function cmmLmIsDone _
Lib "Cmmsdk.dll" _
(ByVal LmIndex As Long, ByRef IsDone As Long) _
As Long

Public Declare Function cmmLmWaitDone _
Lib "Cmmsdk.dll" _
(ByVal LmIndex As Long, ByVal IsBlocking As Long) _
As Long

Public Declare Function cmmLmCurSequence _
Lib "Cmmsdk.dll" _
(ByVal LmIndex As Long, ByRef SeqIndex As Long) _
As Long

Public Declare Function cmmLmImmediacySet _
Lib "Cmmsdk.dll" _
(ByVal LmIndex As Long) _
As Long

Public Declare Function cmmLmDoPutOne _
Lib "Cmmsdk.dll" _
(ByVal LmIndex As Long, ByVal hDoDevice As Long, ByVal Channel As Long, ByVal OutState As Long) _
As Long

Public Declare Function cmmLmDoPutMulti _
Lib "Cmmsdk.dll" _
(ByVal LmIndex As Long, ByVal hDoDevice As Long, ByVal ChannelGroup As Long, ByVal Mask As Long, ByVal OutStates As Long) _
As Long

Public Declare Function cmmLmDoPulseOne _
Lib "Cmmsdk.dll" _
(ByVal LmIndex As Long, ByVal hDoDevice As Long, ByVal Channel As Long, ByVal OutState As Long, ByVal Duration As Long) _
As Long

Public Declare Function cmmLmDoPulseMulti _
Lib "Cmmsdk.dll" _
(ByVal LmIndex As Long, ByVal hDoDevice As Long, ByVal ChannelGroup As Long, ByVal Mask As Long, ByVal OutStates As Long, ByVal Duration As Long) _
As Long

'====================== ° FUNCTIONS ===================================================
Public Declare Function cmmStSetCount _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Target As Long, ByVal Count As Long) _
As Long

Public Declare Function cmmStGetCount _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Source As Long, ByRef Count As Long) _
As Long

Public Declare Function cmmStSetPosition _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Target As Long, ByVal Position As Double) _
As Long

Public Declare Function cmmStGetPosition _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Source As Long, ByRef Position As Double) _
As Long

Public Declare Function cmmStGetSpeed _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Source As Long, ByRef Speed As Double) _
As Long

Public Declare Function cmmStReadMotionState _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef MotStates As Long) _
As Long

Public Declare Function cmmStReadMioStatuses _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef MioStates As Long) _
As Long

Public Declare Function cmmStGetMstString _
Lib "Cmmsdk.dll" _
(ByVal MstCode As Long, ByRef Buffer As String, ByVal BufferLen As Long) _
As Long

'====================== INTERRUPT FUNCTIONS ==================================================
Public Declare Function cmmIntSetMask _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Mask As Long) _
As Long

Public Declare Function cmmIntGetMask _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef Mask As Long) _
As Long

Public Declare Function cmmIntHandlerSetup _
Lib "Cmmsdk.dll" _
(ByVal HandlerType As Long, ByVal Handler As Long, ByVal nMessage As Long, ByVal lParam As Any) _
As Long

Public Declare Function cmmIntHandlerEnable _
Lib "Cmmsdk.dll" _
(ByVal IsEnable As Long) _
As Long

Public Declare Function cmmIntReadFlag _
Lib "Cmmsdk.dll" _
(ByRef IntFlag1 As Long, ByRef IntFlag2 As Long) _
As Long

Public Declare Function cmmIntReadErrorStatus _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef ErrState As Long) _
As Long

Public Declare Function cmmIntReadEventStatus _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef EventState As Long) _
As Long

'====================== LATCH FUNCTIONS =======================================================
Public Declare Function cmmLtcIsLatched _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef IsLatched As Long) _
As Long

Public Declare Function cmmLtcReadLatch _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Counter As Long, ByRef LatchedPos As Double) _
As Long

'====================== Position Compare FUNCTIONS ===========================================
Public Declare Function cmmCmpErrSetConfig _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Tolerance As Double, ByVal IsEnable As Long) _
As Long

Public Declare Function cmmCmpErrGetConfig _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef Tolerance As Double, ByRef IsEnabled As Long) _
As Long

Public Declare Function cmmCmpGenSetConfig _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal CmpSrc As Long, ByVal CmpMethod As Long, ByVal CmpAction As Long, ByVal CmpData As Double) _
As Long

Public Declare Function cmmCmpGenGetConfig _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef CmpSrc As Long, ByRef CmpMethod As Long, ByRef CmpAction As Long, ByRef CmpData As Long) _
As Long

Public Declare Function cmmCmpTrgSetConfig _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal CmpSrc As Long, ByVal CmpMethod As Long) _
As Long

Public Declare Function cmmCmpTrgGetConfig _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef CmpSrc As Long, ByRef CmpMethod As Long) _
As Long

Public Declare Function cmmCmpTrgSetOneData _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Data As Double) _
As Long

Public Declare Function cmmCmpTrgGetCurData _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef Data As Double) _
As Long

Public Declare Function cmmCmpTrgContRegTable _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef Buffer As Double, ByVal NumData As Long) _
As Long

Public Declare Function cmmCmpTrgContBuildTable _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal StartData As Double, ByVal Interval As Double, ByVal NumData As Long) _
As Long

Public Declare Function cmmCmpTrgContStart _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long) _
As Long

Public Declare Function cmmCmpTrgContStop _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long) _
As Long

Public Declare Function cmmCmpTrgContIsActive _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByRef IsActive As Long) _
As Long

Public Declare Function cmmCmpTrgHigh_WriteData _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByVal CMPH_No As Long, ByVal IniPos As Double, ByVal Interval As Double) _
As Long

Public Declare Function cmmCmpTrgHigh_ReadData _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByRef CMPH_No As Long, ByRef IniPos As Double, ByRef Interval As Double) _
As Long

Public Declare Function cmmCmpTrgHigh_Start _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long) _
As Long

Public Declare Function cmmCmpTrgHigh_Stop _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long) _
As Long

Public Declare Function cmmCmpTrgHigh_Check _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByRef IsActive As Long, ByRef OutCount As Long) _
As Long

'
'CMM_EXTERN long        (WINAPI *cmmCmpTrgIx_SetMap)    (long MapIdx, long Axis_X, long Axis_Y, long DoChan);
'CMM_EXTERN long        (WINAPI *cmmCmpTrgIx_GetMap)    (long MapIdx, long *Axis_X, long *Axis_Y, long *DoChan, long *IsValid);
'CMM_EXTERN long        (WINAPI *cmmCmpTrgIx_Start)     (long MapIdx, double PosArray_X[], double PosArray_Y[], long SrcSelArray[], long ArraySize);
'CMM_EXTERN long        (WINAPI *cmmCmpTrgIx_Stop)      (long MapIdx);
'CMM_EXTERN long        (WINAPI *cmmCmpTrgIx_GetState)  (long MapIdx, long *CmpOutCnt, long *IsActive);
'
'
'====================== Digital In/Out FUNCTIONS =============================================
Public Declare Function cmmDiSetInputLogic _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByVal InputLogic As Long) _
As Long

Public Declare Function cmmDiGetInputLogic _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByRef InputLogic As Long) _
As Long

Public Declare Function cmmDiGetOne _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByRef InputState As Long) _
As Long

Public Declare Function cmmDiGetMulti _
Lib "Cmmsdk.dll" _
(ByVal IniChannel As Long, ByVal NumChannels As Long, ByRef InputStates As Long) _
As Long

Public Declare Function cmmDiGetOneF _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByVal CutoffTime_us As Long, ByRef InputState As Long) _
As Long

Public Declare Function cmmDiGetMultiF _
Lib "Cmmsdk.dll" _
(ByVal IniChannel As Long, ByVal NumChannels As Long, ByVal CutoffTime_us As Long, ByRef InputStates As Long) _
As Long

Public Declare Function cmmDoSetOutputLogic _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByVal OutputLogic As Long) _
As Long

Public Declare Function cmmDoGetOutputLogic _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByRef OutputLogic As Long) _
As Long

Public Declare Function cmmDoPutOne _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByVal OutState As Long) _
As Long

Public Declare Function cmmDoGetOne _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByRef OutState As Long) _
As Long

Public Declare Function cmmDoPulseOne _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByVal IsOnPulse As Long, ByVal dwDuration As Long, ByVal IsWaitPulseEnd As Long) _
As Long

Public Declare Function cmmDoPutMulti _
Lib "Cmmsdk.dll" _
(ByVal IniChannel As Long, ByVal NumChannels As Long, ByVal OutStates As Long) _
As Long

Public Declare Function cmmDoGetMulti _
Lib "Cmmsdk.dll" _
(ByVal IniChannel As Long, ByVal NumChannels As Long, ByRef InputStates As Long) _
As Long

Public Declare Function cmmDoPulseMulti _
Lib "Cmmsdk.dll" _
(ByVal IniChannel As Long, ByVal NumChannels As Long, ByVal OutStates As Long, ByVal dwDuration As Long, ByVal IsWaitPulseEnd As Long) _
As Long

'====================== Advanced FUNCTIONS ===================================================
Public Declare Function cmmAdvGetNumAvailAxes _
Lib "Cmmsdk.dll" _
(ByRef NumAxes As Long) _
As Long

Public Declare Function cmmAdvGetNumDefinedAxes _
Lib "Cmmsdk.dll" _
(ByRef NumAxes As Long) _
As Long

Public Declare Function cmmAdvGetNumAvailDioChan _
Lib "Cmmsdk.dll" _
(ByVal IsInputChannel As Long, ByRef NumChannels As Long) _
As Long

Public Declare Function cmmAdvGetNumDefinedDioChan _
Lib "Cmmsdk.dll" _
(ByVal IsInputChannel As Long, ByRef NumChannels As Long) _
As Long

Public Declare Function cmmAdvGetMotDeviceId _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef DeviceId As Long) _
As Long

Public Declare Function cmmAdvGetMotDevInstance _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef DevInstance As Long) _
As Long

Public Declare Function cmmAdvGetDioDeviceId _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal IsInputChannel As Long, ByRef DeviceId As Long) _
As Long

Public Declare Function cmmAdvGetDioDevInstance _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal IsInputChannel As Long, ByRef DevInstance As Long) _
As Long

Public Declare Function cmmAdvGetDeviceHandle _
Lib "Cmmsdk.dll" _
(ByVal DeviceId As Long, ByVal DevInstance As Long, ByRef DevHandle As Long) _
As Long

Public Declare Function cmmAdvWriteMainSpace _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Addr As Long, ByVal Value As Long) _
As Long

Public Declare Function cmmAdvReadMainSpace _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Addr As Long, ByRef Value As Long) _
As Long

Public Declare Function cmmAdvWriteRegister _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal RegisterNo As Long, ByVal RegVal As Long) _
As Long

Public Declare Function cmmAdvReadRegister _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal RegisterNo As Long, ByRef RegVal As Long) _
As Long

Public Declare Function cmmAdvGetMioCfg1Dword _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByRef Mio1Dword As Long) _
As Long

Public Declare Function cmmAdvSetMioCfg1Dword _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal Mio1Dword As Long) _
As Long

Public Declare Function cmmAdvSetToolboxMode _
Lib "Cmmsdk.dll" _
(ByVal EnInterrupt As Long) _
As Long

Public Declare Function cmmAdvGetString _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal StringID As Long, ByRef szBuffer As String) _
As Long

Public Declare Function cmmAdvErcOut _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long, ByVal IsWaitOff As Long) _
As Long

Public Declare Function cmmAdvErcReset _
Lib "Cmmsdk.dll" _
(ByVal Axis As Long) _
As Long

Public Declare Function cmmAdvSetExtOptions _
Lib "Cmmsdk.dll" _
(ByVal OptionId As Long, ByVal lParam1 As Long, ByVal lParam2 As Long, ByVal fParam1 As Double, ByVal fParam2 As Double) _
As Long

'CMM_EXTERN long (WINAPI *cmmAdvEnumMotDevices) (TMotDevEnum *EnumBuffer);

'CMM_EXTERN long (WINAPI *cmmAdvGetMotDevMap)   (TMotDevMap *MapBuffer);

'CMM_EXTERN long (WINAPI *cmmAdvEnumDioDevices) (TDioDevEnum *EnumBuffer);

'CMM_EXTERN long (WINAPI *cmmAdvGetDioDevMap)   (TDioDevMap *MapBuffer);

'CMM_EXTERN long (WINAPI *cmmAdvInitFromCmeBuffer) (TCmeData_V2 *pCmeBuffer);

'CMM_EXTERN long (WINAPI *cmmAdvInitFromCmeBuffer_MapOnly) (TCmeData_V2 *pCmeBuffer, int nMapType);

Public Declare Function cmmAdvGetLatestCmeFile _
Lib "Cmmsdk.dll" _
(ByRef szCmeFile As String) _
As Long

Public Declare Function cmmAdvGetAxisCapability _
Lib "Cmmsdk.dll" _
(ByVal Channel As Long, ByVal CapId As Long, ByRef CapBuffer As Long) _
As Long

'====================== DEBUG-LOGGING FUNCTIONS ==============================================
Public Declare Function cmmDlogSetup _
Lib "Cmmsdk.dll" _
(ByVal Level As Long, ByRef szLogFile As String) _
As Long

Public Declare Function cmmDlogAddComment _
Lib "Cmmsdk.dll" _
(ByRef szComment As String) _
As Long

Public Declare Function cmmDlogGetCurLevel _
Lib "Cmmsdk.dll" _
(ByRef CurLevel As Long) _
As Long

Public Declare Function cmmDlogGetCurFilePath _
Lib "Cmmsdk.dll" _
(ByRef szFilePath As String) _
As Long

'====================== ERROR HANDLING FUNCTIONS =============================================
Public Declare Function cmmErrGetLastCode _
Lib "Cmmsdk.dll" _
(ByRef ErrorCode As Long) _
As Long

Public Declare Function cmmErrParseAxis _
Lib "Cmmsdk.dll" _
(ByVal ErrorCode As Long) _
As Long

Public Declare Function cmmErrParseReason _
Lib "Cmmsdk.dll" _
(ByVal ErrorCode As Long) _
As Long

Public Declare Function cmmErrGetString _
Lib "Cmmsdk.dll" _
(ByVal ErrorCode As Long, ByRef Buffer As String, ByVal BufferLen As Long) _
As Long

Public Declare Function cmmErrShowLast _
Lib "Cmmsdk.dll" _
(ByVal ParentWnd As Long) _
As Long

Public Declare Function cmmErrSetSkipShowMessage _
Lib "Cmmsdk.dll" _
(ByVal IsSkip As Long) _
As Long

Public Declare Function cmmErrGetSkipShowMessage _
Lib "Cmmsdk.dll" _
(ByRef IsSkip As Long) _
As Long

Public Declare Function cmmErrSetEnableAutoMessage _
Lib "Cmmsdk.dll" _
(ByVal Enable As Long) _
As Long

Public Declare Function cmmErrGetEnableAutoMessage _
Lib "Cmmsdk.dll" _
(ByRef Enabled As Long) _
As Long

'====================== Utility FUNCTIONS ===================================================
Public Declare Function cmmUtlProcessWndMsgS _
Lib "Cmmsdk.dll" _
(ByVal WndHandle As Long, ByRef IsEmpty As Long) _
As Long

Public Declare Function cmmUtlProcessWndMsgM _
Lib "Cmmsdk.dll" _
(ByVal WndHandle As Long, ByVal TimeOut As Long, ByRef IsTimeOuted As Long) _
As Long

Public Declare Function cmmUtlReadUserTable _
Lib "Cmmsdk.dll" _
(ByVal hDevice As Long, ByVal nAddress As Long, ByVal nSize As Long, ByRef pBuffer As String) _
As Long

Public Declare Function cmmUtlWriteUserTable _
Lib "Cmmsdk.dll" _
(ByVal hDevice As Long, ByVal nAddress As Long, ByVal nSize As Long, ByRef pBuffer As String) _
As Long

Public Declare Function cmmUtlDelayMicroSec _
Lib "Cmmsdk.dll" _
(ByVal Delay_us As Long) _
As Long

